/*----------------------------------------------------- BTP Error Handling */
#include <errno.h>
#include <stdlib.h>

#include <flpda/Widget_Factory.h>
#include <FL/Fl_Multiline_Output.H>

#include "btp.h"
#include "btpErrors.h"

void cb_okbutton(Fl_Widget *w, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
}
void cb_fatalbutton(Fl_Widget *w, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
  exit(EXIT_FAILURE);       // There's _got_ to be a prettier way to do this!
}
int btperror(char *text, int fatal=0) {
  Fl_Window *btperrorwindow = 
     new Fl_Window(0, 25, D_WIDTH, R_HEIGHT, "BTP Error");
  btperrorwindow->set_modal();
  Fl_Multiline_Output *multiline = new Fl_Multiline_Output(
    R_BORDER, R_BORDER, R_WIDTH-R_BORDER*2, R_HEIGHT-R_BOTTOM-R_BORDER, ""
  );
  multiline->textsize(10);             // Text, value, what's the difference?
  multiline->value(text);
  //multiline->align(FL_ALIGN_WRAP | FL_ALIGN_CLIP); //Nah, appearantly impossible. *sigh*
  if(!fatal) {
    Fl_Button *okbutton = new Fl_Button(
      R_BORDER, R_HEIGHT-R_BOTTOM, R_WIDTH-R_BORDER*2, R_BOTTOM-R_BORDER, "OK"
    );
    okbutton->labelsize(10);
    okbutton->callback(cb_okbutton, btperrorwindow);
  } else {
    Fl_Button *fatalbutton = new Fl_Button(
      R_BORDER, R_HEIGHT-R_BOTTOM, R_WIDTH-R_BORDER*2, R_BOTTOM-R_BORDER,"EXIT"
    );
    fatalbutton->labelsize(10);
    fatalbutton->callback(cb_fatalbutton, btperrorwindow);
  }
  btperrorwindow->show();
  return(0);
}
