/*
   Buttons To Press 6.3.2
   Support for using the AgVr3r hardbuttons added by 
   Enrique Vidal, evidal@iti.upv.es, Feb, 2002.

   Buttons To Press 6.3.1
   Martin "Sam" Samuelsson, sam@home.se, 2002-01-02
   A mostly-no-frills FLTK GUI for rc, made specially for use with
   the Agenda PDA by Agenda Computing.

   Buttons To Press 6.0
   Ronald Rael Harvest, six@thevillage.dhs.org, 2001-11-19
   A modification of Buttons To Press 1.0 to make it read irremote
   config files.

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   /Sam
*/
#include <X11/Xlib.h>
#include <X11/keysym.h>

#include <FL/Fl.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Multiline_Output.H>

//-ifdef AGVR3
#include <Flek/Fl_App_Window.H>
#include <flpda/Widget_Factory.h>
//-endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/un.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>

#define LIRCD "/dev/lircd" //Probably shouldn't be hard coded.

#define D_WIDTH  160
#define D_HEIGHT 240
#define R_WIDTH  160
#define R_HEIGHT 100
#define R_BORDER 2
#define R_BOTTOM 16

#define UnknownInd  -1
#define Shift_LInd   0
#define Shift_RInd   1
#define LeftInd      2
#define RightInd     3
#define Page_UpInd   4
#define Page_DownInd 5

#define Shift_L   "Shift_L"
#define Shift_R   "Shift_R"
#define Left      "Left"
#define Right     "Right"
#define Page_Up   "Page_Up"
#define Page_Down "Page_Down"

#ifdef AGVR3
#define Shift_R_Code  24  // Shift_R code for Agenda
#else
#define Shift_R_Code  62  // Shift_R code for host
#endif
KeySym ks;
Display *Xdisp;

int rcsend(char *command, int fd);

void *prevData=NULL;  // global pointer to last-button-press data
int fd;               // The socket.

int Xerr(Display *displ, XErrorEvent *z) {       // Catch possible errors of
  char buf[100];                                // changing Xfree key mappings
  XGetErrorText(displ, z->error_code, buf, 100);
  printf("Xfree ERROR: %s\n", buf);
  return z->error_code;
}

void cb_okbutton(Fl_Widget *w, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
}

void cb_fatalbutton(Fl_Widget *w, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
  exit(EXIT_FAILURE); // There's _got_ to be a prettier way to do this!
}

int btperror(char *text, int fatal=0) {
  Fl_Window *btperrorwindow = 
     new Fl_Window(0, 25, D_WIDTH, R_HEIGHT, "BTP Error");
  btperrorwindow->set_modal();
  Fl_Multiline_Output *multiline = new Fl_Multiline_Output(
      R_BORDER, R_BORDER, R_WIDTH-R_BORDER*2, R_HEIGHT-R_BOTTOM-R_BORDER, ""
  );
  multiline->textsize(10); // Text, value, what's the difference?
  multiline->value(text);
  if(!fatal) {
    Fl_Button *okbutton = new Fl_Button(
        R_BORDER, R_HEIGHT-R_BOTTOM, R_WIDTH-R_BORDER*2, R_BOTTOM-R_BORDER, "OK"
    );
    okbutton->labelsize(10);
    okbutton->callback(cb_okbutton, btperrorwindow);
  } else {
    Fl_Button *fatalbutton = new Fl_Button(
        R_BORDER, R_HEIGHT-R_BOTTOM, 
        R_WIDTH-R_BORDER*2, R_BOTTOM-R_BORDER, "EXIT"
    );
    fatalbutton->labelsize(10);
    fatalbutton->callback(cb_fatalbutton, btperrorwindow);
  }
  btperrorwindow->show();
  return(0);
}

void cb_button(Fl_Widget *w, void *data) {
  rcsend((char *)data, fd);
  prevData = data;
}

void cb_done(Fl_Widget *widget, void *data) {
  //#ifdef AGVR3
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
#ifdef AGVR3
  ks = XK_Shift_L;
#else
  ks = XK_Shift_R;
#endif
  Xdisp=XOpenDisplay(NULL); // Restore the standard Shift_R 
  XChangeKeyboardMapping(Xdisp, Shift_R_Code, 1, &ks, 1);
  XCloseDisplay(Xdisp);

  close(fd);
  exit(EXIT_SUCCESS); 
}

void rcHdSend(char *data) {
  // fprintf(stderr, "-- %s\n", data);
  if (!strncasecmp(data, ".prev", 5))  
     {if (prevData!=NULL) rcsend((char *)prevData, fd);}
  else                    rcsend(data, fd);
}

int main(int argc, char** argv) {

FILE *rcfile;
Fl_Button *button[100];	 // This is the max under irremote
char command[100][80];   // Macros can be pretty large... And this thing
                         // _should_ be cleaned up!
char t[1024]; 		 // 80 characters my ASS!
                         // *grin* Ok!
char hdcomm[6][80]={"","","","","",""};  // The hadrbutton commands

/// struct sigaction act;
struct sockaddr_un addr;
int nextButton = 0;
int labelsize = 10;
int show_toolbar = 1;
int layoutgood = 0;

        int i=0; if (!Fl::args(argc,argv,i)) Fl::fatal(Fl::help);
        const char* fname = (i < argc) ? argv[i] : "remote.ini";

	//#ifdef AGVR3
        Fl_App_Window *btpwindow = WidgetFactory::new_window("BTP 6.3.2");
	//#else
	//	Fl_Window *btpwindow = new Fl_Window(160,240,"BTP 6.3.2");
	//#endif
	Fl_Group *btpgroup = new Fl_Group(
          btpwindow->x(), btpwindow->y(), btpwindow->w(), btpwindow->h()
        );
	btpgroup->window()->resizable(btpgroup);

	if ((rcfile = fopen(fname, "r"))) {
	  while (fgets(t, 1024, rcfile)) {
	    if (!strncasecmp(t, "toolbar", 7)) {
	      char *parseable = index(t, '=') + 1;
	      
	      if (!strncasecmp(parseable, "show", 4)) {
		show_toolbar = 1;
	      } else {
		show_toolbar = 0;
	      }
	    }
	    
	    if (!strncasecmp(t, "labelsize", 9)) {
	      char *parseable = index(t, '=') + 1;
	      labelsize = atoi(strtok(parseable, ",\n"));
	    }
            // ----------------------------------------------------------
	    if (!strncasecmp(t, "hardbutton", 10)) { // Parse hardbuttons
              int j=UnknownInd;
	      char *parseable = index(t, '=') + 1;
	      char *key = strdup(strtok(parseable, ","));
	      char *remote = strdup(strtok(NULL, ",\n"));
              char *remoteCode;
	      if (!strncasecmp(remote, ".prev", 5)) remoteCode = "";
              else remoteCode = strdup(strtok(NULL, "\n"));

	      if(strlen(remote)+1+strlen(remoteCode)>=80) { 
		puts("RemoteCode (macro?) too long!\n"); exit(-1);
	      }

      	      if      (strcmp(key, Shift_L)   == 0) j=Shift_LInd;
      	      else if (strcmp(key, Shift_R)   == 0) j=Shift_RInd;
      	      else if (strcmp(key, Left)      == 0) j=LeftInd;
      	      else if (strcmp(key, Right)     == 0) j=RightInd;
      	      else if (strcmp(key, Page_Up)   == 0) j=Page_UpInd;
      	      else if (strcmp(key, Page_Down) == 0) j=Page_DownInd; 
 
              if (j>=0) sprintf(hdcomm[j], "%s %s", remote, remoteCode);
	      else      fprintf(stderr, "Hard button unknown: %s\n", key);

              // fprintf(stderr, "--- %d %s - %s-\n", j, key, hdcomm[j]);
	    }
	    // ----------------------------------------------------------

	    if (!strncasecmp(t, "button", 6)) {
	      char *parseable = index(t, '=') + 1;
	      int x = atoi(strtok(parseable, ","));
	      int y = atoi(strtok(NULL, ","));
	      int width = atoi(strtok(NULL, ","));
	      int height = atoi(strtok(NULL, ","));
	      char *label = strdup(strtok(NULL, ","));
	      char *remote = strdup(strtok(NULL, ","));
	      char *remoteCode = strdup(strtok(NULL, "\n"));
	      
	      // x,y,width,height,label,remote,remoteCode\n
	      // x,y,width,height,label,remote,
              // remoteCode(\n|[,remoteCode|,remote:remoteCode]...\n)
	      // Phew...
	      // No, a dedicated "macro remote" would be simpler and 
              // more compatible.

	      if(strlen(remote)+1+strlen(remoteCode)>=80) { 
                //Uh-hum, buffer overflows are nasty.
		puts("RemoteCode (macro?) too long!\n");
                //Has to be windowified.
		exit(-1);
	      }
	      
	      sprintf(command[nextButton], "%s %s", remote, remoteCode);
	      
	      button[nextButton] = new Fl_Button(x, y, width, height, label);
	      button[nextButton]->labeltype(FL_SYMBOL_LABEL);
	      button[nextButton]->labelsize(labelsize);
	      button[nextButton]->callback(cb_button, command[nextButton]);

	      nextButton++;
	    }
	  }
	  layoutgood = 1;
	  fclose(rcfile);
	}
	btpgroup->end();
///     btpwindow->end();

	//#ifdef AGVR3
        if(show_toolbar) {
	   Fl_Dockable_Window* toolbar = WidgetFactory::new_toolbar();
	   Widget_Factory::new_button("Done", cb_done, btpwindow);
	   btpwindow->add_dockable(toolbar, 1);
	   toolbar->end();  
	}
	//#else
	//	sprintf(command[nextButton], "%s", "");
	//
	//        button[nextButton] = new Fl_Button(3, 222, 37, 17, "done");
	//        button[nextButton]->labeltype(FL_SYMBOL_LABEL);
	//        button[nextButton]->labelsize(10);
	//        button[nextButton]->callback(cb_done, command[nextButton]);
	//#endif
	btpwindow->end();
	btpwindow->show();   

	//This bit is from rcsend. I want to get rid of the (probably miniscule)
	//overhead of opening and connecting to the socket for every command.

	if(layoutgood) {
	  addr.sun_family=AF_UNIX;
	  strcpy(addr.sun_path,LIRCD);
	  fd=socket(AF_UNIX,SOCK_STREAM,0);
	  if(fd==-1) {
	    btperror("Could not open socket\n\nIs lircd running?", 1);
	    // I know, but I really don't like applications just dying.
	    //		perror(progname);
	    //		exit(EXIT_FAILURE);
	    //		return(EXIT_FAILURE);
	  }
	  if(connect(fd,(struct sockaddr *)&addr,sizeof(addr))==-1) {
	    btperror("Could not connect to socket\n\nIs lircd running?", 1);
	    // Same goes here.
	    //		perror(progname);
	    //		exit(EXIT_FAILURE);
	    //		return(EXIT_FAILURE);
	  }
	  // Bit end. cb_done() will take care of closing fd for us.
	} else {
	  btperror("Layout error!\nCould not open remote.ini\n", 1);
	  // exit(-1);
	}

        XSetErrorHandler(Xerr);
        ks = XK_Shift_R;
        Xdisp=XOpenDisplay(NULL);                 // Set the Shift_R button
        XChangeKeyboardMapping(Xdisp, Shift_R_Code, 1, &ks, 1);
        XCloseDisplay(Xdisp);

      	while (Fl::wait()) { char c;
	  int k = Fl::event_key(); // Bad idea, needed for AgVr3 FL_Left/Right
          if (k==0) continue;        
          // fprintf(stderr, ">>>> %u\n", k);
      	  if      (Fl::event_key(FL_Shift_L) && strlen(hdcomm[Shift_LInd]))
                  {c='l'; rcHdSend(hdcomm[Shift_LInd]);}
     	  else if (Fl::event_key(FL_Shift_R) && strlen(hdcomm[Shift_RInd]))
                  {c='r'; rcHdSend(hdcomm[Shift_RInd]);}
//	  else if (Fl::event_key(FL_Left))   // Pity: does'nt work on AgVr3 !?
      	  else if (k==FL_Left && strlen(hdcomm[LeftInd]))
                  {c='L'; rcHdSend(hdcomm[LeftInd]);}
//	  else if (Fl::event_key(FL_Right))  // Pity: does'nt work on AgVr3 !?
      	  else if (k==FL_Right && strlen(hdcomm[RightInd]))
                  {c='R'; rcHdSend(hdcomm[RightInd]);}
      	  else if (Fl::event_key(FL_Page_Up) && strlen(hdcomm[Page_UpInd]))
                  {c='U'; rcHdSend(hdcomm[Page_UpInd]);}
      	  else if (Fl::event_key(FL_Page_Down) && strlen(hdcomm[Page_DownInd]))
                  {c='D'; rcHdSend(hdcomm[Page_DownInd]);} 
      	  else    {c='X';}
      	  // if (c != 'X') fprintf(stderr, "---> %c\n", c);
      	}

///     return Fl::run();
}
