/*
   Buttons To Press 6.2
   Martin "Sam" Samuelsson, sam@home.se, 2002-01-02
   A mostly-no-frills FLTK GUI for rc, made specially for use with
   the Agenda PDA by Agenda Computing.

   Buttons To Press 6.0
   Ronald Rael Harvest, six@thevillage.dhs.org, 2001-11-19
   A modification of Buttons To Press 1.0 to make it read irremote
   config files.

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   /Sam
*/
#include <FL/Fl.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Window.H>
#include <FL/Fl_Output.H>
#include <FL/Fl_Multiline_Output.H>
#include <Flek/Fl_App_Window.H>

#include <flpda/Widget_Factory.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <sys/wait.h>

#define D_WIDTH 160
#define D_HEIGHT 240
#define R_WIDTH 160
#define R_HEIGHT 100
#define R_BORDER 2
#define R_BOTTOM 16

int rcsend(char *command);

void cb_okbutton(Fl_Widget *w, void *data) 
{
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
}

int btperror(char *text) {
  Fl_Window *btperrorwindow = new Fl_Window(0, 25, D_WIDTH, R_HEIGHT, "BTP Error");
  btperrorwindow->set_modal();
  Fl_Multiline_Output *multiline = new Fl_Multiline_Output(R_BORDER, R_BORDER, R_WIDTH-R_BORDER*2, R_HEIGHT-R_BOTTOM-R_BORDER, "");
  multiline->value(text);
  Fl_Button *okbutton = new Fl_Button(R_BORDER, R_HEIGHT-R_BOTTOM, R_WIDTH-R_BORDER*2, R_BOTTOM-R_BORDER, "OK");
  okbutton->callback(cb_okbutton, btperrorwindow);
  btperrorwindow->show();
  return(0);
}

void cb_button(Fl_Widget *w, void *data) 
{
/*
	char *parseable = strdup((char *)data);
	char *remote = strtok(parseable, " ");
	char *code = strtok(NULL, " ");

	switch (fork())
	{
		case 0:
			execl("/bin/rc", "/bin/rc", "SEND_ONCE", remote, code, 0);
		case -1:
			exit(-1);
			break;
		default:
			wait(NULL);
			free(parseable);
			break;
	}
*/

	rcsend((char *)data);
}

void cb_done(Fl_Widget *widget, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
}

int main(int argc, char** argv) {
FILE *rcfile;
Fl_Button *button[100];	 // This is the max under irremote
char command[100][40];
char t[1024]; 		 // 80 characters my ASS!
                         // *grin* Ok!
int nextButton = 0;
int labelsize = 10;
 int show_toolbar = 1;

	if (!(rcfile = fopen("remote.ini", "r"))) 
	{
		puts("Could not open remote.ini!\n");
		exit(-1);
	}

	Fl_App_Window *btpwindow = WidgetFactory::new_window("BTP 6.2");
	
	Fl_Group *btpgroup = new Fl_Group(btpwindow->x(), btpwindow->y(), btpwindow->w(), btpwindow->h());
	btpgroup->window()->resizable(btpgroup);
	while (fgets(t, 1024, rcfile))
	{

		if (!strncasecmp(t, "toolbar", 7))
		{
			char *parseable = index(t, '=') + 1;
			
			if (!strncasecmp(parseable, "show", 4)) {
			  show_toolbar = 1;
			} else {
			  show_toolbar = 0;
			}
		}

		if (!strncasecmp(t, "labelsize", 9))
		{
			char *parseable = index(t, '=') + 1;
			
			labelsize = atoi(strtok(parseable, ",\n"));
		}

		if (!strncasecmp(t, "button", 6))
		{
			char *parseable = index(t, '=') + 1;
			
			int x = atoi(strtok(parseable, ","));
			int y = atoi(strtok(NULL, ","));
			int width = atoi(strtok(NULL, ","));
			int height = atoi(strtok(NULL, ","));
			char *label = strdup(strtok(NULL, ","));
			char *remote = strdup(strtok(NULL, ","));
			char *remoteCode = strdup(strtok(NULL, ",\n"));

			sprintf(command[nextButton], "SEND_ONCE %s %s", remote, remoteCode);

			button[nextButton] = new Fl_Button(x, y, width, height, label);
			button[nextButton]->labeltype(FL_SYMBOL_LABEL);
			button[nextButton]->labelsize(labelsize);
			button[nextButton]->callback(cb_button, command[nextButton]);

			nextButton++;
		}
	}
	btpgroup->end();
	//	btpwindow->end();

	if(show_toolbar) {
	  Fl_Dockable_Window* toolbar = WidgetFactory::new_toolbar();
	  Widget_Factory::new_button("Done", cb_done, btpwindow);
	  btpwindow->add_dockable(toolbar, 1);
	  toolbar->end();  
	}

	btpwindow->end();
	btpwindow->show();   
	return Fl::run();
}
