/*
   Buttons To Press 1.0
   Martin "Sam" Samuelsson, sam@home.se, 2001-06-04
   A mostly-no-frills FLTK GUI for rc, made specially for use with
   the Agenda PDA by Agenda Computing.

   Improvements over version 0.1:

   BTP now embraces and extends rc from the xrc package. Not using system()
   gives a tremendous increase in speed and responsivity, exactly as I
   thought.

   BTP now has a slightly less stupid config file, which made it much
   easier to implement image buttons, requested by Stefan Szomraky. This
   was accomplished using Fl_Pix_Button by Curtis Edwards,

-
Fl_Pix_Button for WidgetSet, Copyright (c) 1998 curtis Edwards (curt1@jps.net)
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both the
copyright notice and this permission notice appear in supporting
documentation.  All work developed as a consequence of the use of
this program should duly acknowledge such use. No representations are
made about the suitability of this software for any purpose.  It is
provided "as is" without express or implied warranty.
-

   and Fl_XPM, snatched from Agenda Computing's launchpad.

   BTP also support, to some extent, different button sizes. This was Stefan's
   idea, too. This is done by specifying the number of columns and rows in the
   config file. Oblong buttons are possible.

   The code is still very much C-with-a-bunch-of-C++-thrown-in. I still don't
   know a word C++.

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   /Sam
*/
#include <FL/Fl.H>
#include <FL/Fl_Button.H>
#include <Flek/Fl_App_Window.H>

#include "Fl_Pix_Button.H"

#include "Fl_XPM.H"

#include <flpda/Widget_Factory.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

#define D_WIDTH 160
#define D_HEIGHT 224

void cb_button(Fl_Widget *w, void *data) {
  //  puts((char *)data);
  rcsend((char *)data); //Should be a lot faster than system().
}

void cb_done(Fl_Widget *widget, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
}

int main(int argc, char** argv) {
FILE *rcfile;
Fl_Button *button[5][7]; // Lazy. I'm used to higher level languages. :)
                         // This kind of declarations make nice security holes
                         // if the input from the config file isn't checked
                         // _thoroughly_.
                         // Naturally, it isn't.
                         // Well, there's some checks now, post-V1,
                         // though not nearly enough.
char label[5][7][20];    // Laaazy.
char command[5][7][40];  // Laaazy!
Fl_Pixmap *up_pixmap[5][7];
Fl_Pixmap *dn_pixmap[5][7];

char temporary[80]; // 80 bytes ought to be enough for everybody.
int yoff;
int args;
int arg1;

int xcols=5;
int yrows=7;
int xylock=0;

char arg0[80];
char arg2[80];
char arg3[80];

 rcfile = fopen(".btprc", "r"); // Should probably be per-user, not global.
   if(!rcfile) {
     puts("Could not find .btprc!");
     exit(0); // I'm not sure what the return code for "failed" is. Better not
              // to guess, I believe.
   }

   fgets(temporary, 80, rcfile);
   if(strcmp(temporary, "V2\n")) {
     puts("Wrong .btprc file format.");
     exit(0);
   }
   
   Fl_App_Window* window = WidgetFactory::new_window("BTP");

   yoff=0;
   while(fgets(temporary, 80, rcfile)) {
     args=sscanf(temporary, "%s %d %s %[^;]s", arg0, &arg1, arg2, arg3);

     if(strcmp(arg0, "cols")==0) {
       if(arg1>0 && arg1<6 && xylock==0) {
         xcols = arg1;
       } else {
         puts("Error in cols directive!");
         exit(0);
       }
     }

     if(strcmp(arg0, "rows")==0) {
       if(arg1>0 && arg1<8 && xylock==0) {
         yrows = arg1;
       } else {
         puts("Error in rows directive!");
         exit(0);
       }
     }

     if(strcmp(arg0, "row")==0) {
       xylock=1;
       if(arg1<yrows && arg1>=0) {
         yoff=arg1;
       } else {
         printf("Row %d out of range!\n", arg1);
         exit(0);
       }
     }

     if(strcmp(arg0, "button")==0) {
       xylock=1;
       if(arg1<xcols && arg1>=0) {

         strncpy(label[arg1][yoff], arg2, 19);
         strncpy(command[arg1][yoff], arg3, 39);

         button[arg1][yoff] = new Fl_Button((D_WIDTH/xcols)*arg1, (D_HEIGHT/yrows)*yoff, (D_WIDTH/xcols), (D_HEIGHT/yrows), label[arg1][yoff]);
         if(!strncmp(arg2, "@", 1)) {
           button[arg1][yoff]->labeltype(FL_SYMBOL_LABEL);
         }
         button[arg1][yoff]->callback(cb_button, command[arg1][yoff]);

       } else {
         printf("Column %d out of range!\n", arg1);
         exit(0);
       }
     }

     if(strcmp(arg0, "image")==0) {
       xylock=1;
       if(arg1<xcols && arg1>=0) {

         strncpy(label[arg1][yoff], arg2, 19);
         strncpy(command[arg1][yoff], arg3, 39);

         sprintf(temporary, "btp-images/up_%s", label[arg1][yoff]);
         up_pixmap[arg1][yoff] = Fl_XPM::read(temporary);
         sprintf(temporary, "btp-images/dn_%s", label[arg1][yoff]);
         dn_pixmap[arg1][yoff] = Fl_XPM::read(temporary);

         button[arg1][yoff] = new Fl_Pix_Button((D_WIDTH/xcols)*arg1, (D_HEIGHT/yrows)*yoff, D_WIDTH/xcols, D_HEIGHT/yrows, NULL, up_pixmap[arg1][yoff], dn_pixmap[arg1][yoff], NULL);
         button[arg1][yoff]->callback(cb_button, command[arg1][yoff]);

       } else {
         printf("Column %d out of range!\n", arg1);
         exit(0);
       }
     }
   }
   
   window->end();
   Fl_Dockable_Window* toolbar = WidgetFactory::new_toolbar();
   Widget_Factory::new_button("Done", cb_done, window);
   window->add_dockable(toolbar, 1);
   toolbar->end();  
   window->show();   
   return Fl::run();
}
