// Fl_XPM.cxx
// 
//
// Copyright (C) 2000 Agenda Computing Inc.
// Written by Derek K.T. Au <phantom@netcom.ca>
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#include "Fl_XPM.H"
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

char* Fl_XPM::read_line(const char* s, char** next) {
	char* c = (char*)s;
	char* d;
	int length = 0;
	char* line;
	while(*c != '"') {
		c++;
	}
	c++;
	
	d = c;
	while(*d != '"') {
		d++;
	}
	
	length = d - c;
	
	line = (char*)malloc(length + 1);
	if(!line) {
		return 0;
	}
	
	memcpy(line, c, length);
	line[length] = 0;
	*next = d + 1;

	
	return line;
}

Fl_Pixmap* Fl_XPM::read(char* filename) {
	char** array;
	char* source;
	int fd;
	struct stat stat_buf;

	char* header;
	char* next;

	int w, h, p;
	
	fd = open(filename, O_RDONLY);
	if(fd < 0) {
		return (Fl_Pixmap*)0;
	}

	fstat(fd, &stat_buf);
	
	source = (char*)mmap(0, stat_buf.st_size, PROT_READ, MAP_SHARED, fd, 0);

	header = read_line(source, &next);

	sscanf(header, "%d %d %d", &w, &h, &p);
		
	array = new (char*)[h + p + 1];
	array[0] = header;
	
	for(int i = 0; i < (h + p); i++) {
		array[i + 1] = read_line(next, &next);
	}	
	
	munmap(source, stat_buf.st_size);
	close(fd);

	return new Fl_Pixmap(array);
}

void Fl_XPM::delete_pixmap(Fl_Pixmap* image) {
	char** data = (char**)image->data;
	int w, h, p;
	
	sscanf(data[0], "%d %d %d", &w, &h, &p);
	for(int i = 0; i < h + p + 1; i++) {
		free(data[i]);
	}
	delete[] data;
	delete image;
}
