/*
   Buttons To Press 0.1
   Martin "Sam" Samuelsson, 2001-05-05
   A no-frills FLTK frontend to rc, made specially for use with
   the Agenda PDA by Agenda Computing.
   License: Public Domain

   BTP would probably benefit immensely from having the system() calls
   thrown out and replaced by the same mechanism used in rc. Doing this was
   not my primary goal with this project, as I mostly wanted to look at how
   FLTK, Flek and flpda work. Structurally, it would probably benefit from
   some C-to-C++ recoding, as I know absolutely nothing about C++.

   /Sam
*/
#include <FL/Fl.H>
#include <FL/Fl_Button.H>
#include <Flek/Fl_App_Window.H>
#include <flpda/Widget_Factory.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>

void cb_button(Fl_Widget *w, void *data) {
  puts((char *)data);
  system((char *)data);
}

void cb_done(Fl_Widget *widget, void *data) {
  Fl_Window* window = reinterpret_cast<Fl_Window*>(data);
  window->hide();
}

int main(int argc, char** argv) {
FILE *rcfile;
Fl_Button *button[5][7]; // Lazy. I'm used to higher level languages. :)
                         // This kind of declarations make nice security holes
                         // if the input from the config file isn't checked
                         // _thoroughly_.
                         // Naturally, it isn't.
char label[5][7][20];    // Laaazy.
char command[5][7][40];  // Laaazy!

char temporary[80]; // 80 bytes ought to be enough for everybody.
int yoff;
int args;
int arg1;

char arg2[80];
char arg3[80];

 rcfile = fopen(".btprc", "r"); // Should probably be per-user, not global.
   if(!rcfile) {
     puts("Could not find .btprc!");
     exit(0); // I'm not sure what the return code for "failed" is. Better not
              // to guess, I believe.
   }

   fgets(temporary, 80, rcfile);
   if(strcmp(temporary, "V1\n")) {
     puts("Wrong .btprc file format.");
     exit(0);
   }
   
   Fl_App_Window* window = WidgetFactory::new_window("BTP");

   yoff=0;
   while(fgets(temporary, 80, rcfile)) {
     args=sscanf(temporary, "%d %s %[^;]s", &arg1, arg2, arg3);
     if(args==1) {
       yoff=arg1;
     }
     if(args==3) {
       strncpy(label[arg1][yoff], arg2, 19);
       strncpy(command[arg1][yoff], arg3, 39);

       button[arg1][yoff] = new Fl_Button(32*arg1, 32*yoff, 32, 32, label[arg1][yoff]);
       if(!strncmp(arg2, "@", 1)) {
         button[arg1][yoff]->labeltype(FL_SYMBOL_LABEL);
       }
       button[arg1][yoff]->callback(cb_button, command[arg1][yoff]);
     }
   }
   
   window->end();
   Fl_Dockable_Window* toolbar = WidgetFactory::new_toolbar();
   Widget_Factory::new_button("Done", cb_done, window);
   window->add_dockable(toolbar, 1);
   toolbar->end();  
   window->show();   
   return Fl::run();
}
